import { __awaiter, __extends, __generator } from "tslib";
import { WebPlugin } from './index';
import { PermissionType } from '../core-plugin-definitions';
var PermissionsPluginWeb = /** @class */ (function (_super) {
    __extends(PermissionsPluginWeb, _super);
    function PermissionsPluginWeb() {
        return _super.call(this, {
            name: 'Permissions'
        }) || this;
    }
    PermissionsPluginWeb.prototype.query = function (options) {
        return __awaiter(this, void 0, void 0, function () {
            var navigator, name, ret;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        navigator = window.navigator;
                        if (!navigator.permissions) {
                            return [2 /*return*/, Promise.reject('This browser does not support the Permissions API')];
                        }
                        name = options.name === PermissionType.Photos ? 'camera' : options.name;
                        return [4 /*yield*/, navigator.permissions.query({ name: name })];
                    case 1:
                        ret = _a.sent();
                        return [2 /*return*/, {
                                state: ret.state
                            }];
                }
            });
        });
    };
    return PermissionsPluginWeb;
}(WebPlugin));
export { PermissionsPluginWeb };
var Permissions = new PermissionsPluginWeb();
export { Permissions };
//# sourceMappingURL=permissions.js.map